/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.data;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class RelativeShape {
    private String structure = null;
    private List<BlockPos> shape;
    private int count;

    public RelativeShape(RelativeShape other) {
        this.shape = other.shape;
        this.count = other.count;
    }

    public RelativeShape() {
        this.shape = new ArrayList<BlockPos>();
    }

    public void merge(RelativeShape other) {
        this.shape.addAll(other.shape);
        this.count = this.shape.size();
    }

    public RelativeShape(Level world, List<BlockPos> options, BlockPos center) {
        this();
        this.shape = options;
        if (world != null && center != null) {
            this.setWorldCenter(world, center);
        }
    }

    public void setWorldCenter(Level world, BlockPos center) {
        if (world != null) {
            List<BlockPos> options = this.shape;
            this.shape = new ArrayList<BlockPos>();
            for (BlockPos pos : options) {
                BlockState bs = world.m_8055_(pos);
                if (bs.m_60795_()) continue;
                this.shape.add(pos.m_142082_(-1 * center.m_123341_(), -1 * center.m_123342_(), -1 * center.m_123343_()));
            }
        }
        this.count = this.shape.size();
    }

    public int getCount() {
        return this.count;
    }

    public String getStructure() {
        return this.structure;
    }

    public void setStructure(String structure) {
        this.structure = structure;
    }

    public List<BlockPos> getShape() {
        return this.shape;
    }

    public static RelativeShape read(CompoundTag tag) {
        if (tag == null || !tag.m_128471_("cyclic-shape")) {
            return null;
        }
        int count = tag.m_128451_("count");
        ArrayList<BlockPos> shapeList = new ArrayList<BlockPos>();
        for (int i = 0; i < count; ++i) {
            shapeList.add(new BlockPos(tag.m_128451_("x" + i), tag.m_128451_("y" + i), tag.m_128451_("z" + i)));
        }
        RelativeShape shape = new RelativeShape();
        shape.shape = shapeList;
        shape.count = shapeList.size();
        return shape;
    }

    public static RelativeShape read(ItemStack item) {
        CompoundTag tag = item.m_41783_();
        return RelativeShape.read(tag);
    }

    public CompoundTag write(CompoundTag tag) {
        int i = 0;
        int count = 0;
        for (BlockPos p : this.shape) {
            tag.m_128405_("x" + i, p.m_123341_());
            tag.m_128405_("y" + i, p.m_123342_());
            tag.m_128405_("z" + i, p.m_123343_());
            count = ++i;
        }
        tag.m_128405_("count", count);
        tag.m_128379_("cyclic-shape", true);
        return tag;
    }

    public void write(ItemStack shapeCard) {
        CompoundTag tag = shapeCard.m_41784_();
        this.write(tag);
    }

    public void setShape(List<BlockPos> list) {
        this.shape = list;
        this.count = this.shape.size();
    }
}

